IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'EST_MOVIMENTO_VENDAS_PRODUTOS') 
					AND type in (N'U')) 
BEGIN
CREATE TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS](
	[CD_CTR_VENDAS] [int] NOT NULL,
	[CD_EMP] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[VLR_VD] [money] NOT NULL,
	[VLR_DESC_ITENS] [money] NOT NULL,
	[VLR_VD_LIQ] [money] NOT NULL,
	[VLR_PMC] [money] NOT NULL,
	[VLR_CUSTO_MD] [money] NOT NULL,
	[VLR_CUSTO_GER] [money] NOT NULL,
	[VLR_CUSTO] [money] NOT NULL,
	[VLR_DESC_OFERTA] [money] NOT NULL,
	[VLR_DESC_VERBA] [money] NOT NULL,
	[VLR_DESC_RATEIO] [money] NOT NULL,
	[VLR_ICMS] [money] NOT NULL,
	[VLR_PIS_COFINS] [money] NOT NULL,
	[QTDE_ITENS] [money] NOT NULL,
 CONSTRAINT [PK_EST_MOVIMENTO_VENDAS_PRODUTOS] PRIMARY KEY CLUSTERED 
(
	[CD_CTR_VENDAS] ASC,
	[CD_EMP] ASC,
	[CD_PROD] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_Table_1_CD_ARV_MERC_CATEG_1]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_VD]  DEFAULT ((0)) FOR [VLR_VD]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DESC_ITENS]  DEFAULT ((0)) FOR [VLR_DESC_ITENS]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_VD_LIQ]  DEFAULT ((0)) FOR [VLR_VD_LIQ]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_PMC]  DEFAULT ((0)) FOR [VLR_PMC]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CUSTO_MD]  DEFAULT ((0)) FOR [VLR_CUSTO_MD]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CUSTO_GER]  DEFAULT ((0)) FOR [VLR_CUSTO_GER]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_CUSTO]  DEFAULT ((0)) FOR [VLR_CUSTO]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DESC_OFERTA]  DEFAULT ((0)) FOR [VLR_DESC_OFERTA]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DESC_VERBA]  DEFAULT ((0)) FOR [VLR_DESC_VERBA]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_DESC_RATEIO]  DEFAULT ((0)) FOR [VLR_DESC_RATEIO]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_ICMS]  DEFAULT ((0)) FOR [VLR_ICMS]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_VLR_PIS_COFINS]  DEFAULT ((0)) FOR [VLR_PIS_COFINS]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] ADD  CONSTRAINT [DF_EST_MOVIMENTO_VENDAS_PRODUTOS_QTDE_ITENS]  DEFAULT ((0)) FOR [QTDE_ITENS]

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS]  WITH CHECK ADD  CONSTRAINT [FK_EST_MOVIMENTO_VENDAS_PRODUTOS_EST_MOVIMENTO_VENDAS] FOREIGN KEY([CD_CTR_VENDAS])
REFERENCES [dbo].[EST_MOVIMENTO_VENDAS] ([CD_CTR_VENDAS])
ON UPDATE CASCADE
ON DELETE CASCADE

ALTER TABLE [dbo].[EST_MOVIMENTO_VENDAS_PRODUTOS] CHECK CONSTRAINT [FK_EST_MOVIMENTO_VENDAS_PRODUTOS_EST_MOVIMENTO_VENDAS]
end